(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     26483,        807]
NotebookOptionsPosition[     25064,        752]
NotebookOutlinePosition[     25532,        770]
CellTagsIndexPosition[     25489,        767]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Din\[AAcute]mica inversa del robot RR usando la formulaci\[OAcute]n de \
Euler-Lagrange
Listado de c\[OAcute]digo fuente\
\>", "Title",
 CellChangeTimes->{{3.9057806128910465`*^9, 3.905780653242488*^9}, {
  3.9060388375970044`*^9, 3.906038841871933*^9}, {3.9060389075360327`*^9, 
  3.906038912650915*^9}},
 TextAlignment->Center,ExpressionUUID->"f610d709-4022-4716-98c1-b7cfbbc060e8"],

Cell["R. Pe\[OAcute]n. F. Pe\[NTilde]u\[NTilde]uri, C. Cab", "Subtitle",
 CellChangeTimes->{{3.9060389200542693`*^9, 3.9060389284720507`*^9}},
 TextAlignment->Center,ExpressionUUID->"edf647c1-11e8-4688-9c94-366572eb2772"],

Cell[CellGroupData[{

Cell["Vector de coordenadas generalizadas", "Section",
 CellChangeTimes->{{3.90578108706007*^9, 
  3.905781098229765*^9}},ExpressionUUID->"70434bd4-b5a4-4527-abe8-\
e0d1c9f95c57"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"q", "[", "t_", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Theta]", "1"], "[", "t", "]"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Theta]", "2"], "[", "t", "]"}], "}"}]}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qd", "[", "t", "]"}], "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"q", "[", "t", "]"}], ",", "t"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qd2", "[", "t", "]"}], "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"qd", "[", "t", "]"}], ",", "t"}], "]"}]}], ";"}]}], "Input",
 ExpressionUUID -> "9157e3fa-135f-413a-932c-da7d49cdcc58"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Tensor de inercia y vector de posici\[OAcute]n del C.G. del i-\[EAcute]simo \
eslab\[OAcute]n \
\>", "Section",
 CellChangeTimes->{{3.9057806663600636`*^9, 3.905780730129733*^9}, {
  3.906038950755169*^9, 3.9060389528246727`*^9}, {3.9061324206701384`*^9, 
  3.9061324445699368`*^9}, {3.906132505050808*^9, 
  3.9061325069269323`*^9}},ExpressionUUID->"d2875aed-1b76-4efc-a825-\
11e881993dd4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["I", "1"], "=", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["h", "xx1"], "0", "0"},
       {"0", 
        SubscriptBox["h", "yy1"], "0"},
       {"0", "0", 
        SubscriptBox["h", "zz1"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["I", "2"], "=", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["h", "xx2"], "0", "0"},
       {"0", 
        SubscriptBox["h", "yy2"], "0"},
       {"0", "0", 
        SubscriptBox["h", "zz2"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["r", "1"], "=", 
   RowBox[{"(", GridBox[{
      {
       RowBox[{
        SubscriptBox["lc", "1"], "*", 
        RowBox[{"Sin", "[", 
         RowBox[{
          SubscriptBox["\[Theta]", "1"], "[", "t", "]"}], "]"}]}]},
      {
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["lc", "1"]}], "*", 
        RowBox[{"Cos", "[", 
         RowBox[{
          SubscriptBox["\[Theta]", "1"], "[", "t", "]"}], "]"}]}]},
      {"0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["r", "2"], "=", 
   RowBox[{"(", GridBox[{
      {
       RowBox[{
        RowBox[{
         SubscriptBox["l", "1"], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{
           SubscriptBox["\[Theta]", "1"], "[", "t", "]"}], "]"}]}], "+", 
        RowBox[{
         SubscriptBox["lc", "2"], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{
            SubscriptBox["\[Theta]", "1"], "[", "t", "]"}], "+", 
           RowBox[{
            SubscriptBox["\[Theta]", "2"], "[", "t", "]"}]}], "]"}]}]}]},
      {
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SubscriptBox["l", "1"]}], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{
           SubscriptBox["\[Theta]", "1"], "[", "t", "]"}], "]"}]}], "-", 
        RowBox[{
         SubscriptBox["lc", "2"], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{
            SubscriptBox["\[Theta]", "1"], "[", "t", "]"}], "+", 
           RowBox[{
            SubscriptBox["\[Theta]", "2"], "[", "t", "]"}]}], "]"}]}]}]},
      {"0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], ")"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9061325204072647`*^9, 3.9061325209069138`*^9}},
 ExpressionUUID -> "a8162b01-b213-49f5-8939-9129e0cf2f5e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Matriz de masas e inercia", "Section",
 CellChangeTimes->{{3.870799176711695*^9, 3.870799187208287*^9}, {
  3.906038958158638*^9, 
  3.9060389595671053`*^9}},ExpressionUUID->"cbb381d0-ae97-4ecc-b9ff-\
b4690cb57891"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"jv11", "=", 
   RowBox[{
    SubscriptBox["\[PartialD]", 
     RowBox[{
      SubscriptBox["\[Theta]", "1"], "[", "t", "]"}]], 
    SubscriptBox["r", "1"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"jv12", "=", 
   RowBox[{
    SubscriptBox["\[PartialD]", 
     RowBox[{
      SubscriptBox["\[Theta]", "2"], "[", "t", "]"}]], 
    SubscriptBox["r", "1"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MatrixForm", "[", 
   RowBox[{"Jv1", "=", 
    RowBox[{"Join", "[", 
     RowBox[{"jv11", ",", "jv12", ",", "2"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Jw1", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "0"},
      {"0", "0"},
      {"1", "0"}
     }], "\[NoBreak]", ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"jv21", "=", 
   RowBox[{
    SubscriptBox["\[PartialD]", 
     RowBox[{
      SubscriptBox["\[Theta]", "1"], "[", "t", "]"}]], 
    SubscriptBox["r", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"jv22", "=", 
   RowBox[{
    SubscriptBox["\[PartialD]", 
     RowBox[{
      SubscriptBox["\[Theta]", "2"], "[", "t", "]"}]], 
    SubscriptBox["r", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MatrixForm", "[", 
   RowBox[{"Jv2", "=", 
    RowBox[{"Join", "[", 
     RowBox[{"jv21", ",", "jv22", ",", "2"}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Jw2", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "0"},
      {"0", "0"},
      {"1", "1"}
     }], "\[NoBreak]", ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", 
  RowBox[{"M", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"m1", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Transpose", "[", "Jv1", "]"}], ".", "Jv1"}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"Transpose", "[", "Jw1", "]"}], ".", 
      SubscriptBox["I", "1"], ".", "Jw1"}], "+", 
     RowBox[{"m2", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Transpose", "[", "Jv2", "]"}], ".", "Jv2"}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"Transpose", "[", "Jw2", "]"}], ".", 
      SubscriptBox["I", "2"], ".", "Jw2"}]}], "]"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.870798508715454*^9, 3.870798608628025*^9}, {
  3.8707986550311785`*^9, 3.8707987204565935`*^9}, {3.8707987698126974`*^9, 
  3.870798794203566*^9}, {3.8707988368693037`*^9, 3.8707988542710485`*^9}, {
  3.870798941708691*^9, 3.8707989419329042`*^9}, {3.870799003744399*^9, 
  3.8707990542045307`*^9}, {3.870799283638485*^9, 3.8707993084502835`*^9}, {
  3.906132475320138*^9, 3.906132478347021*^9}, {3.906132900203009*^9, 
  3.9061329024282613`*^9}},
 ExpressionUUID -> "2b70641e-a8f1-4f68-86fc-30d20ea1e809"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SubscriptBox["h", "zz1"], "+", 
       SubscriptBox["h", "zz2"], "+", 
       RowBox[{"m2", " ", 
        SubsuperscriptBox["l", "1", "2"]}], "+", 
       RowBox[{"m1", " ", 
        SubsuperscriptBox["lc", "1", "2"]}], "+", 
       RowBox[{"2", " ", "m2", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{
          SubscriptBox["\[Theta]", "2"], "[", "t", "]"}], "]"}], " ", 
        SubscriptBox["l", "1"], " ", 
        SubscriptBox["lc", "2"]}], "+", 
       RowBox[{"m2", " ", 
        SubsuperscriptBox["lc", "2", "2"]}]}], 
      RowBox[{
       SubscriptBox["h", "zz2"], "+", 
       RowBox[{"m2", " ", 
        SubscriptBox["lc", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{
             SubscriptBox["\[Theta]", "2"], "[", "t", "]"}], "]"}], " ", 
           SubscriptBox["l", "1"]}], "+", 
          SubscriptBox["lc", "2"]}], ")"}]}]}]},
     {
      RowBox[{
       SubscriptBox["h", "zz2"], "+", 
       RowBox[{"m2", " ", 
        SubscriptBox["lc", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{
             SubscriptBox["\[Theta]", "2"], "[", "t", "]"}], "]"}], " ", 
           SubscriptBox["l", "1"]}], "+", 
          SubscriptBox["lc", "2"]}], ")"}]}]}], 
      RowBox[{
       SubscriptBox["h", "zz2"], "+", 
       RowBox[{"m2", " ", 
        SubsuperscriptBox["lc", "2", "2"]}]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.906132895959721*^9, 3.9061329039737115`*^9}, 
   3.906135356426248*^9, 3.9061356033723383`*^9, 3.9061364767871637`*^9},
 CellLabel->
  "Out[16]//MatrixForm=",ExpressionUUID->"a5d2f18a-6ef3-4ed5-92c2-\
e553d5aeda6c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vector de fuerzas centr\[IAcute]fugas y de Coriolis", "Section",
 CellChangeTimes->{{3.905781123584707*^9, 
  3.9057811504394355`*^9}},ExpressionUUID->"da243d97-fd98-46c9-ade4-\
c47b49261632"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Parte1", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"M", ",", "t"}], "]"}], ".", 
    RowBox[{"qd", "[", "t", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"V2", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"qd", "[", "t", "]"}], "]"}], ".", "M", ".", 
     RowBox[{"qd", "[", "t", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Parte2", "=", 
    RowBox[{
     FractionBox["1", "2"], "*", 
     RowBox[{"(", GridBox[{
        {
         RowBox[{
          SubscriptBox["\[PartialD]", 
           RowBox[{
            RowBox[{"q", "[", "t", "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}]], "V2"}]},
        {
         RowBox[{
          SubscriptBox["\[PartialD]", 
           RowBox[{
            RowBox[{"q", "[", "t", "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}]], "V2"}]}
       }], ")"}]}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", 
  RowBox[{"V", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Parte1", "-", 
     RowBox[{"Flatten", "[", "Parte2", "]"}]}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.9057813335494947`*^9, {3.9061332701070623`*^9, 3.906133296307231*^9}, {
   3.9061340972161465`*^9, 3.906134116545894*^9}, {3.9061353438854136`*^9, 
   3.906135346035689*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"494491d7-6bd8-4863-b039-48d6e9833864"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"-", "m2"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{
         SubscriptBox["\[Theta]", "2"], "[", "t", "]"}], "]"}], " ", 
       SubscriptBox["l", "1"], " ", 
       SubscriptBox["lc", "2"], " ", 
       RowBox[{
        SuperscriptBox[
         SubscriptBox["\[Theta]", "2"], "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{
           SuperscriptBox[
            SubscriptBox["\[Theta]", "1"], "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox[
           SubscriptBox["\[Theta]", "2"], "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}]}], ")"}]}]},
     {
      RowBox[{"m2", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{
         SubscriptBox["\[Theta]", "2"], "[", "t", "]"}], "]"}], " ", 
       SubscriptBox["l", "1"], " ", 
       SubscriptBox["lc", "2"], " ", 
       SuperscriptBox[
        RowBox[{
         SuperscriptBox[
          SubscriptBox["\[Theta]", "1"], "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], "2"]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.906133283637059*^9, 3.90613329679183*^9}, {
   3.906134101762766*^9, 3.9061341173660393`*^9}, {3.9061353468302107`*^9, 
   3.9061353564749184`*^9}, 3.906135603418079*^9, 3.906136476850482*^9},
 CellLabel->
  "Out[20]//MatrixForm=",ExpressionUUID->"3654c375-5af3-4471-9e74-\
90eb81ae757e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vector de fuerzas gravitacionales", "Section",
 CellChangeTimes->{{3.8708000382660303`*^9, 
  3.8708000487408295`*^9}},ExpressionUUID->"71c9e1d7-7eea-4fa2-98e7-\
f628c04a7fde"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"gvec", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0"},
      {
       RowBox[{"-", "g"}]},
      {"0"}
     }], "\[NoBreak]", ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{
    RowBox[{"m1", "*", "Jv1"}], "+", 
    RowBox[{"m2", "*", "Jv2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", 
  RowBox[{"G", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Simplify", "[", 
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Transpose", "[", "gvec", "]"}], ".", "A"}]}], "]"}], "]"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.870800060396215*^9, 3.8708000958126645`*^9}, {
  3.8708002871186495`*^9, 3.870800325976674*^9}, {3.8708003696255007`*^9, 
  3.8708004236208487`*^9}, {3.870800999619811*^9, 3.870801005698191*^9}, {
  3.871403147494191*^9, 3.871403151635665*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"753c07ef-1c26-49b1-bdb3-247d91b3c54e"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"g", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"m2", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{
            SubscriptBox["\[Theta]", "1"], "[", "t", "]"}], "]"}], " ", 
          SubscriptBox["l", "1"]}], "+", 
         RowBox[{"m1", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{
            SubscriptBox["\[Theta]", "1"], "[", "t", "]"}], "]"}], " ", 
          SubscriptBox["lc", "1"]}], "+", 
         RowBox[{"m2", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{
             SubscriptBox["\[Theta]", "1"], "[", "t", "]"}], "+", 
            RowBox[{
             SubscriptBox["\[Theta]", "2"], "[", "t", "]"}]}], "]"}], " ", 
          SubscriptBox["lc", "2"]}]}], ")"}]}]},
     {
      RowBox[{"g", " ", "m2", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{
          SubscriptBox["\[Theta]", "1"], "[", "t", "]"}], "+", 
         RowBox[{
          SubscriptBox["\[Theta]", "2"], "[", "t", "]"}]}], "]"}], " ", 
       SubscriptBox["lc", "2"]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.9061346481267247`*^9, 3.906135356515004*^9, 
  3.9061356034514685`*^9, 3.9061364768828573`*^9},
 CellLabel->
  "Out[23]//MatrixForm=",ExpressionUUID->"c2c03d3a-329e-4c8c-abea-\
932eeb24d729"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Modelo din\[AAcute]mico inverso del robot RR", "Section",
 CellChangeTimes->{{3.8710610488862405`*^9, 3.8710610615054665`*^9}, 
   3.871404732884204*^9},ExpressionUUID->"9403c1b4-5143-4752-a18a-\
adbf0d45dd7a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Tau]", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"M", ".", 
     RowBox[{"qd2", "[", "t", "]"}]}], "+", "V", "+", "G"}], "//", 
   "MatrixForm"}]}]], "Input",
 CellChangeTimes->{{3.871061069305127*^9, 3.8710610794295635`*^9}, {
   3.8710611190855036`*^9, 3.871061158331745*^9}, {3.8710612033891993`*^9, 
   3.8710612056334047`*^9}, 3.906134995036867*^9, {3.906135329590389*^9, 
   3.9061353313454027`*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"866e9aae-6e95-48b7-89c6-9ea4aecd02ea"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"g", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"m2", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{
             SubscriptBox["\[Theta]", "1"], "[", "t", "]"}], "]"}], " ", 
           SubscriptBox["l", "1"]}], "+", 
          RowBox[{"m1", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{
             SubscriptBox["\[Theta]", "1"], "[", "t", "]"}], "]"}], " ", 
           SubscriptBox["lc", "1"]}], "+", 
          RowBox[{"m2", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{
             RowBox[{
              SubscriptBox["\[Theta]", "1"], "[", "t", "]"}], "+", 
             RowBox[{
              SubscriptBox["\[Theta]", "2"], "[", "t", "]"}]}], "]"}], " ", 
           SubscriptBox["lc", "2"]}]}], ")"}]}], "-", 
       RowBox[{"m2", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{
          SubscriptBox["\[Theta]", "2"], "[", "t", "]"}], "]"}], " ", 
        SubscriptBox["l", "1"], " ", 
        SubscriptBox["lc", "2"], " ", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["\[Theta]", "2"], "\[Prime]",
          MultilineFunction->None], "[", "t", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{
            SuperscriptBox[
             SubscriptBox["\[Theta]", "1"], "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}]}], "+", 
          RowBox[{
           SuperscriptBox[
            SubscriptBox["\[Theta]", "2"], "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["h", "zz1"], "+", 
          SubscriptBox["h", "zz2"], "+", 
          RowBox[{"m2", " ", 
           SubsuperscriptBox["l", "1", "2"]}], "+", 
          RowBox[{"m1", " ", 
           SubsuperscriptBox["lc", "1", "2"]}], "+", 
          RowBox[{"2", " ", "m2", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{
             SubscriptBox["\[Theta]", "2"], "[", "t", "]"}], "]"}], " ", 
           SubscriptBox["l", "1"], " ", 
           SubscriptBox["lc", "2"]}], "+", 
          RowBox[{"m2", " ", 
           SubsuperscriptBox["lc", "2", "2"]}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["\[Theta]", "1"], "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["h", "zz2"], "+", 
          RowBox[{"m2", " ", 
           SubscriptBox["lc", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"Cos", "[", 
               RowBox[{
                SubscriptBox["\[Theta]", "2"], "[", "t", "]"}], "]"}], " ", 
              SubscriptBox["l", "1"]}], "+", 
             SubscriptBox["lc", "2"]}], ")"}]}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["\[Theta]", "2"], "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]}]},
     {
      RowBox[{
       RowBox[{"g", " ", "m2", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[Theta]", "1"], "[", "t", "]"}], "+", 
          RowBox[{
           SubscriptBox["\[Theta]", "2"], "[", "t", "]"}]}], "]"}], " ", 
        SubscriptBox["lc", "2"]}], "+", 
       RowBox[{"m2", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{
          SubscriptBox["\[Theta]", "2"], "[", "t", "]"}], "]"}], " ", 
        SubscriptBox["l", "1"], " ", 
        SubscriptBox["lc", "2"], " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox[
           SubscriptBox["\[Theta]", "1"], "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["h", "zz2"], "+", 
          RowBox[{"m2", " ", 
           SubscriptBox["lc", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"Cos", "[", 
               RowBox[{
                SubscriptBox["\[Theta]", "2"], "[", "t", "]"}], "]"}], " ", 
              SubscriptBox["l", "1"]}], "+", 
             SubscriptBox["lc", "2"]}], ")"}]}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["\[Theta]", "1"], "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["h", "zz2"], "+", 
          RowBox[{"m2", " ", 
           SubsuperscriptBox["lc", "2", "2"]}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["\[Theta]", "2"], "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.906134980421027*^9, 3.906134996405978*^9}, {
   3.906135332255288*^9, 3.9061353565250545`*^9}, 3.906135603472513*^9, 
   3.9061364769288855`*^9},
 CellLabel->
  "Out[24]//MatrixForm=",ExpressionUUID->"bf5bae67-e930-457d-90d4-\
182b05353b67"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"EditBar",
WindowSize->{970, 742},
WindowMargins->{{248, Automatic}, {Automatic, 26}},
TaggingRules->{"TryRealOnly" -> False},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->"Default.nb",
ExpressionUUID -> "12a8780b-699a-4b4a-abe3-e6ec4f704dca"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 394, 8, 231, "Title"],
Cell[977, 32, 221, 2, 56, "Subtitle"],
Cell[CellGroupData[{
Cell[1223, 38, 179, 3, 70, "Section"],
Cell[1405, 43, 740, 25, 69, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2182, 73, 401, 8, 70, "Section"],
Cell[2586, 83, 4220, 127, 241, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6843, 215, 221, 4, 70, "Section"],
Cell[CellGroupData[{
Cell[7089, 223, 2790, 81, 315, "Input"],
Cell[9882, 306, 2182, 63, 67, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12113, 375, 198, 3, 66, "Section"],
Cell[CellGroupData[{
Cell[12336, 382, 1479, 42, 175, "Input"],
Cell[13818, 426, 1952, 54, 63, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15819, 486, 182, 3, 66, "Section"],
Cell[CellGroupData[{
Cell[16026, 493, 949, 26, 117, "Input"],
Cell[16978, 521, 1732, 49, 61, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18759, 576, 216, 3, 66, "Section"],
Cell[CellGroupData[{
Cell[19000, 583, 510, 11, 43, "Input"],
Cell[19513, 596, 5511, 151, 116, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

